/*
 * Decompiled with CFR 0.152.
 */
package com.puravidaapps;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=8, description="Extension related to the file component. Version 9 as of 2017-09-10 for App Inventor version nb162 and Companion version 2.44.", category=ComponentCategory.EXTENSION, nonVisible=true, iconName="https://puravidaapps.com/images/taifun16.png", helpUrl="https://puravidaapps.com/file.php")
@SimpleObject(external=true)
@UsesPermissions(permissionNames="android.permission.READ_EXTERNAL_STORAGE, android.permission.WRITE_EXTERNAL_STORAGE")
public class TaifunFile
extends AndroidNonvisibleComponent
implements Component {
    public static final int VERSION = 8;
    private Context context;
    private final Activity activity;
    private static final String LOG_TAG = "TaifunFile";
    private boolean isRepl = false;
    private boolean suppressWarnings;

    public TaifunFile(ComponentContainer container) {
        super(container.$form());
        if (this.form instanceof ReplForm) {
            this.isRepl = true;
        }
        this.context = container.$context();
        this.activity = container.$context();
        Log.d((String)LOG_TAG, (String)"TaifunFile Created");
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="whether Warnings should be suppressed")
    public boolean SuppressWarnings() {
        return this.suppressWarnings;
    }

    @DesignerProperty(editorType="boolean", defaultValue="false")
    @SimpleProperty
    public void SuppressWarnings(boolean suppressWarnings) {
        this.suppressWarnings = suppressWarnings;
    }

    @SimpleFunction(description="Checks whether it is a file or directory.Prefix the filename with / (i.e. relative path) to look for the file  on the SD card. For instance /myFile.txt will look for the file /mnt/sdcard/myFile.txt. If fileOrDirectoryName starts with file:/// you can specify a complete path to the file or directory.")
    public boolean IsDirectory(String fileOrDirectoryName) {
        if (fileOrDirectoryName.startsWith("//")) {
            Log.d((String)LOG_TAG, (String)"IsDirectory: did not check the assets");
            return false;
        }
        String completeFileName = this.completeFileName(fileOrDirectoryName);
        File file = new File(completeFileName);
        if (file.isDirectory()) {
            Log.d((String)LOG_TAG, (String)"it is a directory");
            return true;
        }
        Log.d((String)LOG_TAG, (String)"it is not a directory");
        return false;
    }

    @SimpleFunction(description="Checks whether a file or directory exists.Prefix the filename with / (i.e. relative path) to look for the file  on the SD card. For instance /myFile.txt will look for the file /mnt/sdcard/myFile.txt. To read assets packaged with an application (also works for the Companion) start the filename with // (two slashes). If a fileOrDirectoryName starts with file:/// you can specify a complete path to the file of directory.")
    public boolean Exists(String fileOrDirectoryName) {
        if (fileOrDirectoryName.startsWith("//") && !this.isRepl) {
            try {
                AssetManager am = this.context.getAssets();
                InputStream is = am.open(fileOrDirectoryName.substring(2));
                if (is.available() > 0) {
                    Log.d((String)LOG_TAG, (String)"Exists: file or directory exists");
                    return true;
                }
                Log.d((String)LOG_TAG, (String)"Exists: file or directory does not exist");
                return false;
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return false;
            }
        }
        String completeFileName = this.completeFileName(fileOrDirectoryName);
        File file = new File(completeFileName);
        if (file.exists()) {
            Log.d((String)LOG_TAG, (String)"Exists: file or directory exists");
            return true;
        }
        Log.d((String)LOG_TAG, (String)"Exists: file or directory does not exist");
        return false;
    }

    @SimpleFunction(description="Return file length of a file.Prefix the filename with / (i.e. relative path) to look for the file  on the SD card. For instance /myFile.txt will look for the file /mnt/sdcard/myFile.txt. To read assets packaged with an application (also works for the Companion) start the filename with // (two slashes). If a fileName starts with file:/// you can specify a complete path to the file.")
    public String Length(String fileName) {
        if (fileName.startsWith("//") && !this.isRepl) {
            AssetFileDescriptor afd = null;
            try {
                afd = this.context.getAssets().openFd(fileName.substring(2));
                Long fileLength = afd.getLength();
                Log.d((String)LOG_TAG, (String)("file length= " + fileLength));
                return fileLength.toString();
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return "0";
            }
        }
        String completeFileName = this.completeFileName(fileName);
        File file = new File(completeFileName);
        if (file.exists() && !file.isDirectory()) {
            Long fileLength = file.length();
            Log.d((String)LOG_TAG, (String)("file length= " + fileLength));
            return fileLength.toString();
        }
        Log.d((String)LOG_TAG, (String)"Sorry, file does not exist or is a directory.");
        if (!this.suppressWarnings) {
            Toast.makeText((Context)this.context, (CharSequence)"Sorry, file does not exist or is a directory.", (int)0).show();
        }
        return "0";
    }

    @SimpleFunction(description="Return a list of filenames of a given directory. Use this method for specific directories to get back a result immediately. To get a list for a complete device or sdcard, which may take a few seconds, use the FileListAsync method instead. The complete path to these files is provided. You can filter by extension. To get a list of all files, use * as extension.If a directory starts with file:/// you can specify a complete path to the directory. To include files of all subdirectories, set includeSubdirectories to true, else to false.")
    public Object FileList(String directoryName, String extension, boolean includeSubdirectories) {
        String completePath = this.completeFileName(directoryName);
        Log.d((String)LOG_TAG, (String)("FileList: " + completePath + ", extension: " + extension + ", sub: " + includeSubdirectories));
        List<String> fileNames = new ArrayList<String>();
        if (!directoryName.startsWith("//")) {
            File dirPath = new File(completePath);
            if (dirPath.isDirectory()) {
                fileNames = this.getList(dirPath, extension, includeSubdirectories);
            } else {
                fileNames.add(completePath);
            }
        }
        return fileNames;
    }

    @SimpleFunction(description="Return a list of filenames from the assets (also works for the Companion). Note: during development, you will get all files stored in directory /AppInventor/assets.")
    public Object FileListFromAssets() {
        List<Object> fileNames = new ArrayList();
        if (!this.isRepl) {
            AssetManager am = this.context.getAssets();
            try {
                String[] files = am.list("");
                fileNames = new ArrayList<String>(Arrays.asList(files));
                Log.d((String)LOG_TAG, (String)("listAssetFiles: " + fileNames));
                String[] dir = new String[]{"webkit", "external_comps", "images"};
                for (int j = dir.length - 1; j >= 0; --j) {
                    fileNames.remove(dir[j]);
                }
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            Log.d((String)LOG_TAG, (String)("listAssetFiles2: " + fileNames));
        } else {
            String completePath = this.completeFileName("//");
            File dirPath = new File(completePath);
            fileNames = this.getList(dirPath, "*", false);
        }
        return fileNames;
    }

    @SimpleFunction(description="Create a list of filenames of a given directory. The result will be provided in the AfterFileListAsync event. The complete path to these files is provided. You can filter by extension. To get a list of all files, use * as extension.If a directory starts with file:/// you can specify a complete path to the directory. To include files of all subdirectories, set includeSubdirectories to true, else to false.")
    public void FileListAsync(final String directoryName, final String extension, final boolean includeSubdirectories) {
        AsynchUtil.runAsynchronously((Runnable)new Runnable(){

            public void run() {
                TaifunFile.this.AsyncFileList(directoryName, extension, includeSubdirectories);
            }
        });
    }

    private void AsyncFileList(String directoryName, String extension, boolean includeSubdirectories) {
        String completePath = this.completeFileName(directoryName);
        Log.d((String)LOG_TAG, (String)("FileList: " + completePath + ", extension: " + extension + ", sub: " + includeSubdirectories));
        List<String> fileNames = new ArrayList<String>();
        if (!directoryName.startsWith("//")) {
            File dirPath = new File(completePath);
            if (dirPath.isDirectory()) {
                fileNames = this.getList(dirPath, extension, includeSubdirectories);
            } else {
                fileNames.add(completePath);
            }
        }
        final ArrayList<String> result = fileNames;
        this.activity.runOnUiThread(new Runnable(){

            public void run() {
                TaifunFile.this.AfterFileListAsync(result);
            }
        });
    }

    @SimpleEvent(description="Event indicating that creating a list of files of a given directory has finished.")
    public void AfterFileListAsync(Object fileList) {
        Log.d((String)LOG_TAG, (String)("AfterFileListAsync: " + fileList));
        EventDispatcher.dispatchEvent((Component)this, (String)"AfterFileListAsync", (Object[])new Object[]{fileList});
    }

    private List<String> getList(File parentDir, String extension, boolean includeSubdirectories) {
        String[] fileNames;
        ArrayList<String> inFiles = new ArrayList<String>();
        for (String fileName : fileNames = parentDir.list()) {
            File file = new File(parentDir.getPath() + File.separator + fileName);
            if (file.isDirectory()) {
                if (!includeSubdirectories || parentDir.getPath().contains("/AppInventor/assets")) continue;
                inFiles.addAll(this.getList(file, extension, includeSubdirectories));
                continue;
            }
            if (!fileName.toLowerCase().endsWith("." + extension) && extension.charAt(0) != '*') continue;
            if (parentDir.getPath().contains("/AppInventor/assets")) {
                inFiles.add(fileName);
                continue;
            }
            inFiles.add(parentDir.getPath() + File.separator + fileName);
        }
        return inFiles;
    }

    private String completeFileName(String fileName) {
        File sd = Environment.getExternalStorageDirectory();
        String completeFileName = fileName;
        if (fileName.startsWith("file:///")) {
            completeFileName = fileName.substring(7);
        } else if (fileName.startsWith("//")) {
            fileName = fileName.substring(2);
            completeFileName = this.isRepl ? Environment.getExternalStorageDirectory().getPath() + "/AppInventor/assets/" + fileName : fileName;
        } else if (fileName.startsWith("/")) {
            if (!fileName.startsWith(sd.toString())) {
                completeFileName = sd + fileName;
            }
        } else {
            completeFileName = sd + File.separator + fileName;
        }
        Log.d((String)LOG_TAG, (String)("completeFileName= " + completeFileName));
        return completeFileName;
    }

    @SimpleFunction(description="Delete file. Prefix the filename with / (i.e. relative path) to delete a file on the SD card. For instance /myFile.txt will delete the file /mnt/sdcard/myFile.txt. You can't delete files stored in the assets! If a fileName starts with file:/// you can specify a complete path to the file.")
    public void Delete(String fileName) {
        if (fileName.startsWith("//")) {
            Log.d((String)LOG_TAG, (String)"Delete: Sorry, can't delete a file in the assets.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, can't delete a file in the assets.", (int)0).show();
            }
        } else if (this.IsDirectory(fileName)) {
            Log.d((String)LOG_TAG, (String)"Delete: Sorry, can't delete a directory.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, can't delete a directory.", (int)0).show();
            }
        } else if (!this.Exists(fileName)) {
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, file to delete does not exist.", (int)0).show();
            }
        } else {
            String completeFileName = this.completeFileName(fileName);
            Log.d((String)LOG_TAG, (String)("Delete, completeFileName: " + completeFileName));
            new File(completeFileName).delete();
        }
    }

    @SimpleFunction(description="Copy file. Use this method to copy small files, for large files use the CopyAsync method instead. Prefix the filename with / (i.e. relative path) to copy a file on the SD card. For instance /myFile.txt will copy the file /mnt/sdcard/myFile.txt. To copy assets packaged with an application (also works for the Companion) start the fromFilename with // (two slashes). However you can't copy files to the assets. If a fileName starts with file:/// you can specify a complete path to the file.")
    public void Copy(String fromFileName, String toFileName) {
        this.copyOrMove1(fromFileName, toFileName, "copy", false);
    }

    @SimpleFunction(description="Copy file (async). Use this method to copy large files. The copy process is finished after the Copied event fires.Prefix the filename with / (i.e. relative path) to copy a file on the SD card. For instance /myFile.txt will copy the file /mnt/sdcard/myFile.txt. To copy assets packaged with an application (also works for the Companion) start the fromFilename with // (two slashes). However you can't copy files to the assets. If a fileName starts with file:/// you can specify a complete path to the file.")
    public void CopyAsync(String fromFileName, String toFileName) {
        this.copyOrMove1(fromFileName, toFileName, "copy", true);
    }

    @SimpleFunction(description="Move file. Use this method to move small files, for large files use the MoveAsync method instead.Prefix the filename with / (i.e. relative path) to move a file on the SD card. For instance /myFile.txt will move the file /mnt/sdcard/myFile.txt. You can't move files from or to the assets If a fileName starts with file:/// you can specify a complete path to the file.")
    public void Move(String fromFileName, String toFileName) {
        this.copyOrMove1(fromFileName, toFileName, "move", false);
    }

    @SimpleFunction(description="Move file. Use this method to move large files. The move process is finished after the Moved event fires.Prefix the filename with / (i.e. relative path) to move a file on the SD card. For instance /myFile.txt will move the file /mnt/sdcard/myFile.txt. You can't move files from or to the assets If a fileName starts with file:/// you can specify a complete path to the file.")
    public void MoveAsync(String fromFileName, String toFileName) {
        this.copyOrMove1(fromFileName, toFileName, "move", true);
    }

    private void copyOrMove1(String fromFileName, String toFileName, final String action, boolean async) {
        block22: {
            String message = "";
            boolean error = false;
            if (toFileName.startsWith("//")) {
                message = "Sorry, can't " + action + " a file to the assets.";
                error = true;
            } else if (this.IsDirectory(fromFileName)) {
                message = "Sorry, can't " + action + " a directory.";
                error = true;
            } else if (!this.Exists(fromFileName)) {
                message = "Sorry, file to " + action + " does not exist.";
                error = true;
            } else if (action.equals("move") && fromFileName.startsWith("//")) {
                message = "Sorry, can't move a file from the assets.";
                error = true;
            }
            if (error) {
                Log.d((String)LOG_TAG, (String)("copyOrMove1: " + message));
                if (async) {
                    if (action.equals("move")) {
                        this.Moved(false, message);
                    } else {
                        this.Copied(false, message);
                    }
                } else if (!this.suppressWarnings) {
                    Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
                }
            } else {
                final String completeFromFileName = this.completeFileName(fromFileName);
                final String completeToFileName = this.completeFileName(toFileName);
                Log.d((String)LOG_TAG, (String)("copyOrMove1, completeFromFileName: " + completeFromFileName + ", completeToFileName: " + completeToFileName));
                Integer endIndex = completeToFileName.lastIndexOf("/");
                String outputPath = completeToFileName.substring(0, endIndex);
                File dir = new File(outputPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Boolean copyFileFromAssets = false;
                if (fromFileName.startsWith("//") && !this.isRepl) {
                    copyFileFromAssets = true;
                }
                final Boolean copyFileFromAssetsResult = copyFileFromAssets;
                if (async) {
                    AsynchUtil.runAsynchronously((Runnable)new Runnable(){

                        public void run() {
                            TaifunFile.this.AsyncCopyOrMove(completeFromFileName, completeToFileName, copyFileFromAssetsResult, action);
                        }
                    });
                } else {
                    try {
                        this.copyOrMove2(completeFromFileName, completeToFileName, copyFileFromAssets, action);
                    }
                    catch (FileNotFoundException fnfe1) {
                        String errorMessage = fnfe1.getMessage();
                        Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)fnfe1);
                        fnfe1.printStackTrace();
                        if (!this.suppressWarnings) {
                            Toast.makeText((Context)this.context, (CharSequence)errorMessage, (int)0).show();
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = e.getMessage();
                        Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)e);
                        e.printStackTrace();
                        if (this.suppressWarnings) break block22;
                        Toast.makeText((Context)this.context, (CharSequence)errorMessage, (int)0).show();
                    }
                }
            }
        }
    }

    private void copyOrMove2(String completeFromFileName, String completeToFileName, Boolean copyFileFromAssets, String action) throws Exception {
        int read;
        Log.d((String)LOG_TAG, (String)"copyOrMove2");
        InputStream in = null;
        FileOutputStream out = null;
        in = copyFileFromAssets != false ? this.form.getAssets().open(completeFromFileName) : new FileInputStream(completeFromFileName);
        out = new FileOutputStream(completeToFileName);
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        in.close();
        in = null;
        out.flush();
        ((OutputStream)out).close();
        out = null;
        if (action == "move") {
            Log.d((String)LOG_TAG, (String)"delete");
            new File(completeFromFileName).delete();
        }
    }

    private void AsyncCopyOrMove(String completeFromFileName, String completeToFileName, Boolean copyFileFromAssets, String action) {
        Log.d((String)LOG_TAG, (String)"AsyncCopyOrMove");
        try {
            this.copyOrMove2(completeFromFileName, completeToFileName, copyFileFromAssets, action);
            this.BackToUiThread(true, action + " successful", action);
        }
        catch (FileNotFoundException fnfe1) {
            String errorMessage = fnfe1.getMessage();
            Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)fnfe1);
            fnfe1.printStackTrace();
            this.BackToUiThread(false, errorMessage, action);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)e);
            e.printStackTrace();
            this.BackToUiThread(false, errorMessage, action);
        }
    }

    private void BackToUiThread(final boolean successful, final String response, String action) {
        if (action == "move") {
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    TaifunFile.this.Moved(successful, response);
                }
            });
        } else {
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    TaifunFile.this.Copied(successful, response);
                }
            });
        }
    }

    @SimpleEvent(description="Event indicating that copying a file has finished.")
    public void Copied(boolean successful, String response) {
        Log.d((String)LOG_TAG, (String)"Copied");
        EventDispatcher.dispatchEvent((Component)this, (String)"Copied", (Object[])new Object[]{successful, response});
    }

    @SimpleEvent(description="Event indicating that moving a file has finished.")
    public void Moved(boolean successful, String response) {
        Log.d((String)LOG_TAG, (String)"Moved");
        EventDispatcher.dispatchEvent((Component)this, (String)"Moved", (Object[])new Object[]{successful, response});
    }

    @SimpleFunction(description="Get free Memory Size in bytes of the external storage. Note: this does not have to be SD card, it can also be mount of internal memory.To get the size in KB: divide by 1024, to get the size im MB: divide again by 1024.")
    private long FreeMemorySize() {
        long bytesAvailable = 0L;
        if (Build.VERSION.SDK_INT <= 8) {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            bytesAvailable = (long)stat.getBlockSize() * (long)stat.getAvailableBlocks();
        } else {
            File sd = Environment.getExternalStorageDirectory();
            bytesAvailable = sd.getUsableSpace();
        }
        Log.d((String)LOG_TAG, (String)("Available Bytes: " + bytesAvailable));
        return bytesAvailable;
    }

    @SimpleFunction(description="Get path and filename from media content uri")
    public String GetFileName(String contentUri) {
        Log.d((String)LOG_TAG, (String)"GetFileName");
        String filename = TaifunFile.getPath(this.context, Uri.parse((String)contentUri));
        return filename;
    }

    private static String getPath(Context context, Uri uri) {
        Log.d((String)"TaifunFile File -", (String)("Authority: " + uri.getAuthority() + ", Fragment: " + uri.getFragment() + ", Port: " + uri.getPort() + ", Query: " + uri.getQuery() + ", Scheme: " + uri.getScheme() + ", Host: " + uri.getHost() + ", Segments: " + uri.getPathSegments().toString()));
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            if (TaifunFile.isGooglePhotosUri(uri)) {
                return uri.getLastPathSegment();
            }
            return TaifunFile.getDataColumn(context, uri, null, null);
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }
        return "";
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                DatabaseUtils.dumpCursor((Cursor)cursor);
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(column_index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    @SimpleFunction(description="Return a list of subdirectories of a given directory. The complete path to these subdirectories is provided. If a directory starts with file:/// you can specify a complete path to the directory. The result list does NOT include subdirectories of subdirectories.")
    public Object DirectoryList(String directoryName) {
        String completePath = this.completeFileName(directoryName);
        Log.d((String)LOG_TAG, (String)("DirectoryList: " + completePath));
        ArrayList<String> dirNames = new ArrayList<String>();
        if (!directoryName.startsWith("//")) {
            File dirPath = new File(completePath);
            if (dirPath.isDirectory()) {
                String[] fileNames;
                for (String fileName : fileNames = dirPath.list()) {
                    File dir = new File(dirPath.getPath() + File.separator + fileName);
                    if (!dir.isDirectory()) continue;
                    dirNames.add(dir.getPath());
                }
            }
        } else {
            dirNames.add("");
        }
        return dirNames;
    }

    @SimpleFunction(description="Get content uri from filename")
    public String GetUri(String filename) {
        Log.d((String)LOG_TAG, (String)("getUri" + filename));
        Uri uri = Uri.fromFile((File)new File(filename));
        return uri.toString();
    }

    @SimpleFunction(description="Return available size of given storage directory in Bytes. To get the value in KB, divide by 1024. To get the value in MB, divide by another 1024. To get the value in GB, divide by another 1024.")
    public String AvailableSize(String storageDirectory) {
        Log.d((String)LOG_TAG, (String)"AvailableSize");
        File file = new File(storageDirectory);
        long availableSizeInBytes = file.getFreeSpace();
        return String.valueOf(availableSizeInBytes);
    }

    @SimpleFunction(description="Return a list of available storage directories.")
    public Object AvailableStorageDirectories() {
        Log.d((String)LOG_TAG, (String)"AvailableStorageDirectories");
        StorageUtil storageUtil = new StorageUtil();
        String[] strings = storageUtil.getStorageDirectories(this.context);
        ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(strings));
        return stringList;
    }

    public class StorageUtil {
        private final Pattern DIR_SEPERATOR = Pattern.compile("/");

        public String[] getStorageDirectories(Context context) {
            HashSet<String> rv = new HashSet<String>();
            String rawExternalStorage = System.getenv("EXTERNAL_STORAGE");
            String rawSecondaryStoragesStr = System.getenv("SECONDARY_STORAGE");
            String rawEmulatedStorageTarget = System.getenv("EMULATED_STORAGE_TARGET");
            if (TextUtils.isEmpty((CharSequence)rawEmulatedStorageTarget)) {
                if (Build.VERSION.SDK_INT >= 23) {
                    File[] files;
                    for (File file : files = context.getExternalFilesDirs(null)) {
                        String applicationSpecificAbsolutePath = file.getAbsolutePath();
                        String emulatedRootPath = applicationSpecificAbsolutePath.substring(0, applicationSpecificAbsolutePath.indexOf("Android/data"));
                        rv.add(emulatedRootPath);
                    }
                } else if (TextUtils.isEmpty((CharSequence)rawExternalStorage)) {
                    rv.addAll(Arrays.asList(this.getPhysicalPaths()));
                } else {
                    rv.add(rawExternalStorage);
                }
            } else {
                String rawUserId;
                if (Build.VERSION.SDK_INT < 17) {
                    rawUserId = "";
                } else {
                    String path = Environment.getExternalStorageDirectory().getAbsolutePath();
                    String[] folders = this.DIR_SEPERATOR.split(path);
                    String lastFolder = folders[folders.length - 1];
                    boolean isDigit = false;
                    try {
                        Integer.valueOf(lastFolder);
                        isDigit = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String string = rawUserId = isDigit ? lastFolder : "";
                }
                if (TextUtils.isEmpty((CharSequence)rawUserId)) {
                    rv.add(rawEmulatedStorageTarget);
                } else {
                    rv.add(rawEmulatedStorageTarget + File.separator + rawUserId);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)rawSecondaryStoragesStr)) {
                String[] rawSecondaryStorages = rawSecondaryStoragesStr.split(File.pathSeparator);
                Collections.addAll(rv, rawSecondaryStorages);
            }
            return rv.toArray(new String[rv.size()]);
        }

        private String[] getPhysicalPaths() {
            return new String[]{"/storage/sdcard0", "/storage/sdcard1", "/storage/extsdcard", "/storage/sdcard0/external_sdcard", "/mnt/extsdcard", "/mnt/sdcard/external_sd", "/mnt/external_sd", "/mnt/media_rw/sdcard1", "/removable/microsd", "/mnt/emmc", "/storage/external_SD", "/storage/ext_sd", "/storage/removable/sdcard1", "/data/sdext", "/data/sdext2", "/data/sdext3", "/data/sdext4", "/sdcard1", "/sdcard2", "/storage/microsd"};
        }
    }
}

