/*
 * Decompiled with CFR 0.152.
 */
package com.puravidaapps;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="Extension to zip/unzip files. Version 2b as of 2016-06-08 for App Inventor version ai2extensions7 and Companion version 2.36cdk1.", category=ComponentCategory.EXTENSION, nonVisible=true, iconName="https://puravidaapps.com/images/taifun16.png")
@SimpleObject(external=true)
@UsesPermissions(permissionNames="android.permission.READ_EXTERNAL_STORAGE, android.permission.WRITE_EXTERNAL_STORAGE")
@UsesLibraries(libraries="zip4j_1.3.2.jar")
public class TaifunZip
extends AndroidNonvisibleComponent
implements Component {
    public static final int VERSION = 1;
    private Context context;
    private final Activity activity;
    private static final String LOG_TAG = "TaifunZip";
    private boolean isRepl = false;
    private boolean suppressWarnings;

    public TaifunZip(ComponentContainer container) {
        super(container.$form());
        if (this.form instanceof ReplForm) {
            this.isRepl = true;
        }
        this.context = container.$context();
        this.activity = container.$context();
        Log.d((String)LOG_TAG, (String)"TaifunZip Created");
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="whether Warnings should be suppressed")
    public boolean SuppressWarnings() {
        return this.suppressWarnings;
    }

    @DesignerProperty(editorType="boolean", defaultValue="false")
    @SimpleProperty
    public void SuppressWarnings(boolean suppressWarnings) {
        this.suppressWarnings = suppressWarnings;
    }

    private boolean Exists(String fileOrDirectoryName) {
        if (fileOrDirectoryName.startsWith("//") && !this.isRepl) {
            AssetFileDescriptor afd = null;
            try {
                afd = this.context.getAssets().openFd(fileOrDirectoryName.substring(2));
                Long fileLength = afd.getLength();
                if (fileLength > 0L) {
                    Log.d((String)LOG_TAG, (String)"Exists: file or directory exists");
                    return true;
                }
                Log.d((String)LOG_TAG, (String)"Exists: file or directory does not exist");
                return false;
            }
            catch (IOException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return false;
            }
        }
        String completeFileName = this.completeFileName(fileOrDirectoryName);
        File file = new File(completeFileName);
        if (file.exists()) {
            Log.d((String)LOG_TAG, (String)"Exists: file or directory exists");
            return true;
        }
        Log.d((String)LOG_TAG, (String)"Exists: file or directory does not exist");
        return false;
    }

    private String completeFileName(String fileName) {
        File sd = Environment.getExternalStorageDirectory();
        String completeFileName = fileName;
        if (fileName.startsWith("file:///")) {
            completeFileName = fileName.substring(7);
        } else if (fileName.startsWith("//")) {
            fileName = fileName.substring(2);
            completeFileName = this.isRepl ? Environment.getExternalStorageDirectory().getPath() + "/AppInventor/assets/" + fileName : fileName;
        } else if (fileName.startsWith("/")) {
            if (!fileName.startsWith(sd.toString())) {
                completeFileName = sd + fileName;
            }
        } else {
            completeFileName = sd + File.separator + fileName;
        }
        Log.d((String)LOG_TAG, (String)("completeFileName= " + completeFileName));
        return completeFileName;
    }

    private List<String> getList(File parentDir, String extension, boolean includeSubdirectories) {
        String[] fileNames;
        ArrayList<String> inFiles = new ArrayList<String>();
        for (String fileName : fileNames = parentDir.list()) {
            File file = new File(parentDir.getPath() + File.separator + fileName);
            if (file.isDirectory()) {
                if (!includeSubdirectories) continue;
                inFiles.addAll(this.getList(file, extension, includeSubdirectories));
                continue;
            }
            if (!fileName.toLowerCase().endsWith("." + extension) && extension.charAt(0) != '*') continue;
            inFiles.add(parentDir.getPath() + File.separator + fileName);
        }
        return inFiles;
    }

    @SimpleFunction(description="Unzip file. Use password to unzip AES 256 password protected files.")
    public void Unzip(String zipFileName, final String password) {
        Log.d((String)LOG_TAG, (String)("Unzip: zipFileName: " + zipFileName));
        if (zipFileName.startsWith("//")) {
            Log.d((String)LOG_TAG, (String)"Unzip: Sorry, can't extract to assets.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, can't extract to assets! First copy the zip file to sd card and unzip there.", (int)0).show();
            }
        } else if (!this.Exists(zipFileName)) {
            Log.d((String)LOG_TAG, (String)"Unzip: Sorry, zip file does not exist.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, zip file does not exist.", (int)0).show();
            }
        } else {
            final String completeFileName = this.completeFileName(zipFileName);
            Integer endIndex = completeFileName.lastIndexOf(".");
            final String path = completeFileName.substring(0, endIndex);
            AsynchUtil.runAsynchronously((Runnable)new Runnable(){

                public void run() {
                    try {
                        TaifunZip.this.AsyncUnzip(completeFileName, path, password);
                    }
                    catch (ZipException e) {
                        String message = e.getMessage();
                        Log.e((String)TaifunZip.LOG_TAG, (String)message, (Throwable)e);
                        e.printStackTrace();
                        TaifunZip.this.BackToUiThread(message);
                    }
                }
            });
        }
    }

    private void AsyncUnzip(String completeFileName, String path, String password) throws ZipException {
        Log.d((String)LOG_TAG, (String)("AsyncUnzip, zipname: " + completeFileName + ", path: " + path));
        ZipFile zipFile = new ZipFile(completeFileName);
        if (zipFile.isEncrypted() && password.length() > 0) {
            zipFile.setPassword(password);
        }
        zipFile.extractAll(path);
        try {
            final List<String> fileList = this.getList(new File(path), "*", true);
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    TaifunZip.this.AfterUnzip(fileList);
                }
            });
        }
        catch (Exception e) {
            String message = e.getMessage();
            Log.e((String)LOG_TAG, (String)message, (Throwable)e);
            e.printStackTrace();
            this.BackToUiThread(message);
        }
    }

    @SimpleEvent(description="Event indicating that an Unzip has finished. Parameter fileList will contain the list of files, which have been extracted.")
    public void AfterUnzip(Object fileList) {
        Log.d((String)LOG_TAG, (String)("AfterUnzip: fileList: " + fileList));
        EventDispatcher.dispatchEvent((Component)this, (String)"AfterUnzip", (Object[])new Object[]{fileList});
    }

    @SimpleFunction(description="Zip a directory. Optionally use password to protect the zip file using AES 256 Encrytion.")
    public void Zip(String directoryName, final String password) {
        Log.d((String)LOG_TAG, (String)("Zip: directoryName: " + directoryName));
        final String completeDirectoryName = this.completeFileName(directoryName);
        File file = new File(completeDirectoryName);
        if (directoryName.startsWith("//")) {
            Log.d((String)LOG_TAG, (String)"Unzip: Sorry, can't zip the assets directory.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, can't zip the assets directory.", (int)0).show();
            }
        } else if (!this.Exists(directoryName)) {
            Log.d((String)LOG_TAG, (String)"Zip: Sorry, directory does not exist.");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Sorry, directory does not exist.", (int)0).show();
            }
        } else if (!file.isDirectory()) {
            Log.d((String)LOG_TAG, (String)"Zip: Please select a directory to zip!");
            if (!this.suppressWarnings) {
                Toast.makeText((Context)this.context, (CharSequence)"Please select a directory to zip!", (int)0).show();
            }
        } else {
            AsynchUtil.runAsynchronously((Runnable)new Runnable(){

                public void run() {
                    try {
                        TaifunZip.this.AsyncZip(completeDirectoryName, password);
                    }
                    catch (ZipException e) {
                        String message = e.getMessage();
                        Log.e((String)TaifunZip.LOG_TAG, (String)message, (Throwable)e);
                        e.printStackTrace();
                        TaifunZip.this.BackToUiThread(message);
                    }
                }
            });
        }
    }

    private void AsyncZip(final String completeDirectoryName, String password) throws ZipException {
        Log.d((String)LOG_TAG, (String)("AsyncZip: completeDirectoryName: " + completeDirectoryName + ", password: " + password));
        ZipFile zipFile = new ZipFile(completeDirectoryName + ".zip");
        ZipParameters parameters = new ZipParameters();
        parameters = this.getParameters(password);
        zipFile.addFolder(completeDirectoryName, parameters);
        this.activity.runOnUiThread(new Runnable(){

            public void run() {
                TaifunZip.this.AfterZip(completeDirectoryName + ".zip");
            }
        });
    }

    @SimpleEvent(description="Event indicating that a Zip has finished. The created zip file name will be provided in parameter zipFileName.")
    public void AfterZip(String zipFileName) {
        Log.d((String)LOG_TAG, (String)("AfterZip: zipFileName: " + zipFileName));
        EventDispatcher.dispatchEvent((Component)this, (String)"AfterZip", (Object[])new Object[]{zipFileName});
    }

    private ZipParameters getParameters(String password) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (password.length() > 0) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(99);
            parameters.setAesKeyStrength(3);
            parameters.setPassword(password);
        } else {
            parameters.setEncryptFiles(false);
        }
        return parameters;
    }

    private void BackToUiThread(final String message) {
        this.activity.runOnUiThread(new Runnable(){

            public void run() {
                if (!TaifunZip.this.suppressWarnings) {
                    Toast.makeText((Context)TaifunZip.this.context, (CharSequence)message, (int)0).show();
                }
            }
        });
    }
}

