/*
 * Decompiled with CFR 0.152.
 */
package com.puravidaapps;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.util.Log;
import android.widget.Toast;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.ReplForm;
import java.lang.reflect.Method;

@DesignerComponent(version=2, description="Hotspot Extension. Version 2 as of 2017-12-03 for App Inventor version nb163 and Companion version 2.44.", category=ComponentCategory.EXTENSION, nonVisible=true, iconName="https://puravidaapps.com/images/taifun16.png", helpUrl="https://puravidaapps.com/hotspot.php")
@SimpleObject(external=true)
@UsesPermissions(permissionNames="android.permission.CHANGE_NETWORK_STATE, android.permission.CHANGE_WIFI_STATE, android.permission.ACCESS_WIFI_STATE, android.permission.WRITE_SETTINGS")
public class TaifunHotspot
extends AndroidNonvisibleComponent
implements Component {
    public static final int VERSION = 2;
    private ComponentContainer container;
    private static Context context;
    private final Activity activity;
    private static boolean isRepl;
    private static final String LOG_TAG = "TaifunHotspot";

    public TaifunHotspot(ComponentContainer container) {
        super(container.$form());
        if (this.form instanceof ReplForm) {
            isRepl = true;
        }
        this.container = container;
        context = container.$context();
        this.activity = container.$context();
        Log.d((String)LOG_TAG, (String)"TaifunHotspot Created");
    }

    @SimpleFunction(description="Check, whether wifi hotspot is enabled or not. Returns true or false. ")
    public static boolean IsEnabled() {
        Log.d((String)LOG_TAG, (String)"IsEnabled");
        WifiManager wifimanager = (WifiManager)context.getSystemService("wifi");
        try {
            Method method = wifimanager.getClass().getDeclaredMethod("isWifiApEnabled", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)wifimanager, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @SimpleFunction(description="Toggle wifi hotspot on or off. Returns true in case of success, else false.")
    public static boolean Toggle() {
        Log.d((String)LOG_TAG, (String)"Toggle");
        if (isRepl) {
            Toast.makeText((Context)context, (CharSequence)"You will have to build your app to be able to use this method!", (int)0).show();
            return false;
        }
        WifiManager wifimanager = (WifiManager)context.getSystemService("wifi");
        Object wificonfiguration = null;
        try {
            if (TaifunHotspot.IsEnabled()) {
                wifimanager.setWifiEnabled(false);
            }
            Method method = wifimanager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            method.invoke((Object)wifimanager, wificonfiguration, !TaifunHotspot.IsEnabled());
            return true;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)e);
            return false;
        }
    }

    @SimpleFunction(description="Set wifi hotspot. Returns true in case of success, else false.")
    public static boolean CreateHotspot(String ssid, String password) {
        Log.d((String)LOG_TAG, (String)"CreateHotspot");
        if (isRepl) {
            Toast.makeText((Context)context, (CharSequence)"You will have to build your app to be able to use this method!", (int)0).show();
            return false;
        }
        WifiManager wifimanager = (WifiManager)context.getSystemService("wifi");
        WifiConfiguration wc = new WifiConfiguration();
        wc.SSID = ssid;
        wc.allowedKeyManagement.set(1);
        wc.preSharedKey = password;
        wc.allowedProtocols.set(1);
        wc.allowedAuthAlgorithms.set(0);
        wc.allowedPairwiseCiphers.set(2);
        wc.allowedGroupCiphers.set(2);
        wc.status = 2;
        try {
            if (TaifunHotspot.IsEnabled()) {
                wifimanager.setWifiEnabled(false);
            }
            Method method = wifimanager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            method.invoke((Object)wifimanager, wc, !TaifunHotspot.IsEnabled());
            return true;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)e);
            return false;
        }
    }

    static {
        isRepl = false;
    }
}

